precision mediump float;

//declare uniforms
uniform sampler2D u_texture;
uniform sampler2D _DisplacementTex;
uniform float _DisplacementPowerX;
uniform float _DisplacementPowerY;
uniform vec2 _textureSize;
uniform vec2 _texelSize;

//"in" attributes from our vertex shader
varying vec4 v_color;
varying vec2 v_texCoords;

void main() {
	float factorX = _DisplacementPowerX * _texelSize.x;
	float factorY = _DisplacementPowerY * _texelSize.y;

	vec2 depthCoords = v_texCoords;
	depthCoords.x = depthCoords.x - factorX;
	depthCoords.y = depthCoords.y - factorY;
	vec4 targetMaskValue = texture2D(_DisplacementTex, depthCoords);

	vec2 uvDisplaced = v_texCoords;
	uvDisplaced.x = uvDisplaced.x - factorX * targetMaskValue.x;
	uvDisplaced.y = uvDisplaced.y - factorY * targetMaskValue.y;

	vec4 currentMaskValue = texture2D(_DisplacementTex, v_texCoords);
	// if currentMaskValue is white and targetMaskValue is black then fillRemainingArea is 1
	float fillRemainingArea = step(1.0, currentMaskValue.r * currentMaskValue.g * currentMaskValue.b);
	fillRemainingArea *= (1.0-step(1.0, targetMaskValue.r * targetMaskValue.g * targetMaskValue.b));

	vec4 colorBehindSubject = texture2D(u_texture, v_texCoords + vec2(-factorX, -factorY));
	vec4 imageColor = texture2D(u_texture, uvDisplaced);
	vec4 resultColor = imageColor * (1.0 - fillRemainingArea) + colorBehindSubject * fillRemainingArea;

	gl_FragColor = v_color * resultColor;
}